Attribute VB_Name = "Modulo1"
Option Explicit

Public gFontName As String

Public IniPathParGen As String
Public IniLocalPath As String

Public gChiusuraForzata As Boolean
Public gPostazioneINVIO As Boolean

Public gAzienda As String

Public ConnDBPrimo As ADODB.Connection   'punta all'mdb GENERALE che si trova sotto la directory "[App.path]&\DB\Generale.mdb"
Public gConnPRIMOOpened As Boolean 'Mi indica se la connessione col Database di PRIMO  ATTIVA

Public gSmsUSER As String
Public gSmsPSSW As String
Public gSmsMITT As String

'Variabili per l'invio degli SMS (soprattutto Promemoria)
'Public gSmsAbilitati As Byte     '1=Abilitati
Public gSmsTxtPromem As String   'Testo per gli SMS Promemoria
Public gSmsOrePreavv As Byte     'Ore di Preavviso per inviare l'SMS Promemoria
Public gSmsPrefInter As String   'Prefisso Internazionale
Public gSmsLenAlias As Byte      'Lunghezza Max Campo Alias

Public gOrderIDSMS As Long

Declare Function TerminateProcess Lib "kernel32" (ByVal hProcess As Long, ByVal uExitCode As Long) As Long

'Per leggere nel file INI
Declare Function GetPrivateProfileString Lib "kernel32" Alias "GetPrivateProfileStringA" _
                  (ByVal lpApplicationName As String, _
                   ByVal lpKeyName As Any, _
                   ByVal lpDefault As String, _
                   ByVal lpReturnedString As String, _
                   ByVal nSize As Long, _
                   ByVal lpFileName As String) _
                  As Long

Declare Function WritePrivateProfileString Lib "kernel32" Alias "WritePrivateProfileStringA" _
                  (ByVal lpApplicationName As String, _
                   ByVal lpKeyName As Any, _
                   ByVal lpString As Any, _
                   ByVal lpFileName As String) _
                  As Long



Sub Main()
   
   'Evito che si eseguano pi Sessioni di lavoro
   If App.PrevInstance = True Then
      End
   End If
   
   
   gFontName = "CALIBRI"
   
   
   'Path del ParGen di GetAPP
      IniLocalPath = App.Path + "\ParSmsTools.CNF"
   
      'Imposto i valori di default nel File Ini Locale
         Call WriteINI("AZIONE", "CLOSE", "F", IniLocalPath)
         Call WriteINI("AZIONE", "PAUSE", "F", IniLocalPath)
   
   'Prendo (eventualmente sia stato specificato da PRIMO) il Path del ParGen.CNF _
    (questo si  reso indispensabili dalla parametrizzazione in PRIMO del percorso del ParGen.CNF)
   IniPathParGen = ReadINI("PARAMETRI", "PATH_PARGEN", IniLocalPath)
   
   
      
   'Questo PARAMETRO comanda su tutte le altre configurazioni
      If Len(Trim(IniPathParGen)) = 0 Then
      
         'Controllo se c' un ParGen.CNF nel App.Path e nel qual caso comanda
         If VerificaEsistenzaFile(App.Path & "\ParGen.cnf") Then
            IniPathParGen = App.Path & "\ParGen.cnf"
         Else
            IniPathParGen = App.Path & "\..\..\ParGen.cnf"
         End If
         
      End If
   
'QUINDI -> PRIMA COPNTROLO SE C' IL PARAMETRO NEL ParSmsTools.CNF _
           POI CONTROLLO SE C' IL PARGEN.CNF NELL'APP.PATH _
           ED IN ULTIMA ANALISI PRENDO QUELLO IN App.Path & "\..\..\

      
   'Se arriva qui controllo che il ParGen esista. In caso contrario ESCO
      If VerificaEsistenzaFile(IniPathParGen) = False Then
         MsgBox "ATTENZIONE!" & vbNewLine & _
                "File di configurazione non trovato!" & vbNewLine & _
                "(" & IniPathParGen & ")", vbCritical
         End
      End If
      
      
   
   'Avvio la Form nascosta
   Form1.Hide
   'Form1.Show
End Sub

'Funzione per leggere nel file INI
Public Function ReadINI(ByVal AppName As String, KeyName As String, Filename As String) As String
Dim INIreturn As String
        
    INIreturn = String(255, Chr(0))
    ReadINI = Left(INIreturn, GetPrivateProfileString(AppName, KeyName, "", INIreturn, _
        Len(INIreturn), Filename))
End Function
'Funzione per scrivere nel file INI
Public Sub WriteINI(ByVal AppName As String, KeyName As String, NewString As String, Filename As String)
Dim Flag As Integer
        
    Flag = WritePrivateProfileString(AppName, KeyName, NewString, Filename)
End Sub


'Public Function GetHandlePRIMO() As String
'
'   GetHandlePRIMO = ReadINI("PARAMETRI", "HANDLE", IniPathParGen)  'Per PrimoBackup
'
'End Function


Public Function NonNullo(Argomento As Variant, Optional Numerico As Boolean) As Variant
   If IsNull(Argomento) Then
      If Numerico = False Then
         NonNullo = ""
      Else
         NonNullo = "0"
      End If
   Else
      If Numerico = False Then
         NonNullo = Argomento
      Else
         If IsNumeric(Argomento) = True Then 'Qui faccio un ulteriore controllo se il valore deve essere numerico
            NonNullo = Argomento
         Else
            NonNullo = "0"
         End If
      End If
   End If
End Function

Public Sub MsgInLogFile(Msg As String)
   Dim NumFile As Integer 'per aprire il file di esecuzioni(LOG)
   Dim vStrRec As String
   Dim vNomeFile As String
   
   On Error Resume Next
   
   'If Len(pNomeLog) > 0 Then
   '   vNomeFile = pNomeLog
   'Else
      vNomeFile = "EventLog_" & Format(Date, "yyyy-mm-dd") & ".cnf"
   'End If
      
   Call VerificaEsistenzaPathCartella(App.Path & "\Log")
   
   
   'If pNuovoFile = True Then
   '   Call RinominaFile(App.Path & "\Files\Doc\", vNomeFile)
   'End If
   
   
   NumFile = FreeFile
      
   'Apro il file LOG
   Open App.Path & "\Log\" & vNomeFile For Append As #NumFile     'CREO IL FILE
      
      'Stampo il messaggio (la riga!)
      vStrRec = Format(Date, "yyyy/mm/dd") & "|" & _
                Format(Now, "hh:nn:ss") & "|"
      
      vStrRec = vStrRec & "|" & Replace(Msg, Chr(13) + Chr(10), "")
      vStrRec = vStrRec & "|"
      
      Print #NumFile, vStrRec
      '+{榦ӱ=53?+jV+uY}4A65?AGT6A ???
      
      'STRUTTURA STRINGA : _
      DATA SISTEMA | ORA SISTEMA | STRINGA | CARATTERE DI FINE RIGA ()
      
   'Chiudo il file di LOG
   Close #NumFile
      
   'Questa istuzione mi serve per azzerare eventuali errori che possono verificarsi. In particolarte quando il comando _
    arriva da una form Modale l'istruzione MDIForm1.ActiveForm.Name genera l'errore 91
   On Error GoTo 0
         
End Sub


'*****************************************************
' Scopo......: converte la data in formato mm/gg/aa hh:mm:ss
' Input......: data e ora
' Restituisce: la data nel formato SQL: 'mm/gg/aa hh:mm:ss'
'*****************************************************
'Public Function DataOraSQL(ByVal strData As String, StrOra As Boolean, Optional DataConOra As Boolean) As String
Public Function DataOraSQL(ByVal strData As String, Optional StrOra As Boolean, _
                           Optional OraDB As String, Optional DataConOra As Boolean) As String

   Dim DataEora As String
   Dim vOra As String
   Dim vDat As String

''ACCESS
'   If gTipoDB = 0 Then
      If StrOra Then
         'DataEora = (Mid(StrData, 4, 2) & "/" & Left(StrData, 2) & "/" & Right(StrData, 2)) & " " & Str(Hour(Time)) & ":" & Trim(Str(Minute(Time))) & ":" & Trim(Str(Second(Time)))
         DataEora = Format(strData, "hh:mm")
         DataEora = Replace(strData, ".", ":")
      Else
         vDat = Format(strData, "mm/dd/yyyy")
         If DataConOra = True Then
            vOra = Format(strData, "hh:nn:ss")
         Else
            vOra = Format(OraDB, "hh:nn:ss")
         End If
         vOra = Replace(vOra, ".", ":")
         DataEora = vDat & " " & vOra
         'DataEora = Trim((Mid(StrData, 4, 2)) & "/" & Trim(Left(StrData, 2)) & "/" & Trim(Right(StrData, 2)))
      End If
   
      DataOraSQL = "#" & Trim(DataEora) & "#"

''SQL
'   Else
'      vDat = Format(strData, "yyyy/mm/dd")
'      vOra = OraDB
'
'      If DataConOra = True Then
'         DataOraSQL = "CONVERT(DATETIME, '" & vDat & "',102)"
'      Else
'         DataOraSQL = "CONVERT(DATETIME, '" & vDat & " " & vOra & "', 102)"
'      End If
'
'   End If
   
End Function


'*****************************************************
' Scopo......: converte una stringa in formato SQL,
'              tenendo conto di eventuali apici, in qual caso li raddoppia
'              secondo lo standard delle stringhe SQL.
' Input......: una stringa
' Restituisce: la stringa nel formato SQL con gli apici singoli
'*****************************************************
Public Function VerificaApici(ByVal stringa As Variant) As String

    If IsNull(stringa) Or IsEmpty(stringa) Or stringa = "" Then
        VerificaApici = ""
        Exit Function
    End If
    
   VerificaApici = Replace(stringa, "'", "''")
End Function


Public Sub GetValoriPRIMO() '(Optional pNewRicerca As Boolean)
   Dim vPathDB As String
   
   On Error GoTo GestErr
   
   'TRUE = Deve Gestire l'invio degli SMS; FALSE = Serve solo per mostrare lo stato
   gPostazioneINVIO = (ReadINI("TOOLS", "ABILITA", IniPathParGen) = "1")
   
   gAzienda = ReadINI("AZIENDA", "CODICE_ULTIMA_USATA", IniPathParGen)
   
   If Len(Trim(gAzienda)) = 0 Then
      gChiusuraForzata = True
      Call MsgInLogFile("ERRORE!!! -> Ultima Azienda usata non impostata nel ParGen")
      MsgBox "Ultima Azienda usata non impostata nel ParGen" & vbNewLine & vbNewLine & _
             "(Si consiglia di contattare l'Assistenza il prima possibile!)", vbCritical
      Exit Sub
   End If
   
   vPathDB = ReadINI("CONN_SQL", "PATH_DB", IniPathParGen)
   'Call MsgInLogFile("   > Path Db: " & vPathDB)
   
   If Len(Trim(vPathDB)) = 0 Then
      gChiusuraForzata = True
      Call MsgInLogFile("ERRORE!!! -> Path DB non trovato")
      MsgBox "Path DB non trovato" & vbNewLine & vbNewLine & _
             "(Si consiglia di contattare l'Assistenza il prima possibile!)", vbCritical
      Exit Sub
   End If
      
   If ApriConnessioneDBPrimo(vPathDB) = False Then
      gChiusuraForzata = True
      Exit Sub
   End If


   'QUI PRELEVO IL VALORE IP DAL DB NEI DATIAZIENDA ED IMPOSTO LA STRINGA DI CONNESSIONE _
    ACCERTANDOMI CHE NON SIA VUOTA
   If GetParamSMS = False Then
      gChiusuraForzata = True
      Exit Sub
   End If
   
   'Imposto a FALSE "F" il parametro AZIONE nel file di configurazione
   'Call WriteINI("AZIONE", "RELOAD_TAB", "F", IniLocalPath)
   Call GetDatiTabPrimo
   
   
GestErr:
   If Err.Number <> 0 Then
      gChiusuraForzata = True
      Call MsgInLogFile("ERRORE!!! -> Funzione GetValoriPRIMO -> " & Err.Number & " - " & Err.Description)
      MsgBox Err.Number & " - " & Err.Description & vbNewLine & vbNewLine & _
             "(Si consiglia di contattare l'Assistenza il prima possibile!)", vbCritical
   End If
   On Error GoTo 0
End Sub

Public Sub GetDatiTabPrimo()
   
   'Inizializzo la Griglia
      Form1.GrigliaDB(0).ClearContent
      Form1.GrigliaDB(0).Columns.DeleteAll
      
      
                                    Form1.GrigliaDB(0).Visible = True
                                    Form1.GrigliaDB(0).ZOrder


'   If pNewRicerca = False Then
   'QUI POPOLO LE TABELLE (REPORTCONTROL) CON I CLIENTI
      Call ReportInsCol(Form1.GrigliaDB(0), "CODICE", "S050T", False, 0, False, False, 0)
      Call ReportInsCol(Form1.GrigliaDB(0), "DESCRIZIONE", "S100T", False, 0, False, False, 1)
                        'GrigliaDB(0).Visible = True
                        'GrigliaDB(0).ZOrder
'
'      Load GrigliaDB(1)
'      Call ReportInsCol(GrigliaDB(1), "CODICE", "S050T", False, 0, False, False, 0)
'      Call ReportInsCol(GrigliaDB(1), "DESCRIZIONE", "S100T", False, 0, False, False, 1)
'                        'GrigliaDB(1).Left = GrigliaDB(0).Left + GrigliaDB(0).Width + 60
'                        'GrigliaDB(1).ZOrder
'                        'GrigliaDB(1).Visible = True
'
'   Else
'      'Suoto le Griglie
'      GrigliaDB(0).ClearContent
'      GrigliaDB(1).ClearContent
'
'   End If
   
   
   'QUI POPOLO LE GRIGLIE
      Dim RS As ADODB.Recordset
      Dim strRicerca As String
      Dim i As Integer
      Dim vTabella As String


      If i = 0 Then
         vTabella = "CLIENTE"
         strRicerca = "SELECT ANCODICE AS dbCODICE,ANDESCRI AS dbDESCRI " & _
                      "  FROM [" & gAzienda & "CONTI] " & _
                      " WHERE (ANTIPCON = 'C') " & _
                      " ORDER BY ANCODICE"
                      '"   AND NOT ((ANCODAPP = '') OR (ISNULL(ANCODAPP))) " &
'         Else
'            vTabella = "SERVIZIO/ARTICOLO"
'            strRicerca = "SELECT ARCODICE AS dbCODICE,ARDESCRI AS dbDESCRI " & _
'                         "  FROM [" & Azienda & "ART_ICOL] " & _
'                         " WHERE (ARFL_WEB = 'SI') " & _
'                         " ORDER BY ARCODICE"
      End If

      Set RS = New ADODB.Recordset
      RS.Open strRicerca, ConnDBPrimo, adOpenStatic
      If RS.EOF = False Then
         With Form1.GrigliaDB(i)
            Do Until RS.EOF
               Call ReportInsRow(Form1.GrigliaDB(i), String(.Columns.Count, ""))    'INSERISCO LA STRINGA

               .Records(.Records.Count - 1).Item(0).Value = RS!dbCODICE
               .Records(.Records.Count - 1).Item(1).Value = RS!dbDESCRI

               RS.MoveNext
            Loop

            'Call MsgInLogFile("   > Acquisito elenco " & IIf(i = 0, "CLIENTI", "SERVIZI/ARTICOLI"))
            .Populate
         End With
      Else
         gChiusuraForzata = True
         Call MsgInLogFile("AVVISO!!! -> Nessun " & vTabella & " abilitato per l'APP")
         Exit Sub
      End If
      RS.Close
      Set RS = Nothing

      
GestErr:
   If Err.Number <> 0 Then
      gChiusuraForzata = True
      Call MsgInLogFile("ERRORE!!! -> Caricam. valori da Tabelle DB -> " & Err.Number & " - " & Err.Description)
      MsgBox Err.Number & " - " & Err.Description & vbNewLine & vbNewLine & _
             "(Si consiglia di contattare l'Assistenza il prima possibile!)", vbCritical
   End If
   On Error GoTo 0

End Sub


Private Function ApriConnessioneDBPrimo(pPathDB As String) As Boolean
   If gConnPRIMOOpened = True Then ApriConnessioneDBPrimo = True: Exit Function
   
   On Error GoTo GestErr

   'Qui mi collego al Database
   Set ConnDBPrimo = New ADODB.Connection
   
   ConnDBPrimo.ConnectionString = "Provider = Microsoft.Jet.OLEDB.4.0;Data Source =" & pPathDB & ";Jet OLEDB:Database Password='primols';"
   ConnDBPrimo.Open
   ConnDBPrimo.CursorLocation = adUseClient
   
   'Call MsgInLogFile("   > Aperta Connessione DB PRIMO")
   
   gConnPRIMOOpened = True
   ApriConnessioneDBPrimo = True

GestErr:
   If Err.Number <> 0 Then
      Call MsgInLogFile("ERRORE!!! -> Connessione al DB PRIMO -> " & Err.Number & " - " & Err.Description)
      MsgBox Err.Number & " - " & Err.Description & vbNewLine & vbNewLine & _
             "(Si consiglia di contattare l'Assistenza il prima possibile!)", vbCritical
   End If
   On Error GoTo 0
End Function

Public Sub ChiudiConnessioneDBPrimo()
   If gConnPRIMOOpened = False Then Exit Sub
   
   On Error Resume Next
   ConnDBPrimo.Close
   gConnPRIMOOpened = False
   'Call MsgInLogFile("   > Chiusa Connessione DB PRIMO")
   'Call MsgInLogFile("    ---^---^---^---^---^---^---^---^---^---^---/^\---^---^---^---^---^---^---^---^---^---^---^---")
End Sub


Private Function GetParamSMS() As Boolean
      Dim RS As ADODB.Recordset
      Dim strRicerca As String
      
      On Error GoTo GestErr
      
   
      strRicerca = "SELECT * " & _
                   "  FROM [ANA_AZIENDE] " & _
                   " WHERE (AZCODAZI = '" & gAzienda & "') "
      Set RS = New ADODB.Recordset
      RS.Open strRicerca, ConnDBPrimo, adOpenStatic
      If RS.EOF = False Then
         
         'USER x TRENDOO
            If Len(Trim(NonNullo(RS!AZSMSUSR))) > 0 Then
               gSmsUSER = Trim(RS!AZSMSUSR)
            Else
               gChiusuraForzata = True
               Call MsgInLogFile("AVVISO!!! -> UTENTE SMS non impostato nei DatiAzienda di PRIMO")
               GoTo SaltaPerErr
            End If
         
         'PASSWORD x TRENDOO
            If Len(Trim(NonNullo(RS!AZSMSPSW))) > 0 Then
               gSmsPSSW = Trim(RS!AZSMSPSW)
            Else
               gChiusuraForzata = True
               Call MsgInLogFile("AVVISO!!! -> PASSWORD SMS non impostata nei DatiAzienda di PRIMO")
               GoTo SaltaPerErr
            End If
         
         'MITTENTE x TRENDOO
            If Len(Trim(NonNullo(RS!AZSMSMIT))) > 0 Then
               gSmsMITT = Trim(RS!AZSMSMIT)
            Else
               gChiusuraForzata = True
               Call MsgInLogFile("AVVISO!!! -> MITTENTE SMS non impostato nei DatiAzienda di PRIMO")
               GoTo SaltaPerErr
            End If
         
         
         'Codifico i parametri per l'URL
            gSmsUSER = CodificaStringaURL(gSmsUSER)
            gSmsPSSW = CodificaStringaURL(gSmsPSSW)
            gSmsMITT = CodificaStringaURL(gSmsMITT)
         
         
         'Variabili per gli SMS (sopartutto Promemoria)
            'gSmsAbilitati = NonNullo(RS!AZSMSABILIT, True)
            gSmsTxtPromem = Trim(NonNullo(RS!AZSMSTXTPRO))
            gSmsOrePreavv = NonNullo(RS!AZSMSOREPRE, True): If gSmsOrePreavv = 0 Then gSmsOrePreavv = 24 'se mancano le imposto di default a 24
            gSmsPrefInter = NonNullo(RS!AZPREFISINT)
            gSmsLenAlias = NonNullo(RS!AZSMSLENALIAS, True)
         
         
      Else
         gChiusuraForzata = True
         Call MsgInLogFile("AVVISO!!! -> Problemi nell'individuazione dell'Indirizzo Web nei DatiAzienda di PRIMO")
         GoTo SaltaPerErr
      End If
      
      GetParamSMS = True
SaltaPerErr:
      RS.Close
      Set RS = Nothing
      
      
GestErr:
   If Err.Number <> 0 Then
      gChiusuraForzata = True
      Call MsgInLogFile("ERRORE!!! -> Caricam. Indirizzo Web da PRIMO -> " & Err.Number & " - " & Err.Description)
      MsgBox Err.Number & " - " & Err.Description & vbNewLine & vbNewLine & _
             "(Si consiglia di contattare l'Assistenza il prima possibile!)", vbCritical
   End If
   On Error GoTo 0

End Function



Public Function AddArrayElement(pArray As Variant, pElement As String) As String() ', Optional pSecondoElement As String) As String()
   'Questa funzione richieder, per funzionare, di due argomenti: l'array su cui operare e l'elemento da aggiungere in coda.

  Dim NewArrSize As Integer
  
  ' Verifico se pArray  una array
   'If IsArray(pArray) Then
   If VerificaArrayInizializzato(pArray) = True Then

      ' Incremento di uno il numero di elementi
      NewArrSize = CInt(UBound(pArray) + 1)
      ReDim Preserve pArray(NewArrSize)
      ' Aggiungo in coda il nuovo elemento (se c' anche il secondo valore lo accodo alla stringa del primoElemento separandolo con "")
      pArray(NewArrSize) = pElement '& " & IIf(Len(Trim(pSecondoElement)) > 0, pSecondoElement, "")"
      
   Else
      ReDim pArray(0)
      pArray(0) = pElement '& " & IIf(Len(Trim(pSecondoElement)) > 0, pSecondoElement, "")"
   End If
   
   AddArrayElement = pArray
   
End Function

Public Function VerificaArrayInizializzato(v_Arr As Variant) As Boolean
   'Questa funzione mi restituisce TRUE se l'array  stato inizializzato
   On Local Error GoTo GestErr
   
   If (LBound(v_Arr) <= UBound(v_Arr)) Then VerificaArrayInizializzato = True

GestErr:
   
End Function



Public Function CodificaStringaURL(pStr As String) As String
   'questa funzione restituisce la stringa codificata per l'URL
   Dim i As Integer
   Dim vStrConv As String
   
   vStrConv = ""
   
   For i = 1 To Len(pStr)
   
      vStrConv = vStrConv & CodificaCharURL(Mid(pStr, i, 1))
      
   Next i
   
   CodificaStringaURL = vStrConv

End Function
Private Function CodificaCharURL(pChar As String) As String
   'questa funziona codifica il carattare nella simbologia adatta all'URL
   Dim vValChar As Integer
   
   vValChar = Asc(pChar)
   
   Select Case vValChar
   Case 48 To 57 'Numeri
      CodificaCharURL = pChar
      Exit Function
   
   Case 65 To 90 'Lettere MAIUSCOLE
      CodificaCharURL = pChar
      Exit Function
    
   Case 97 To 122 'lettere minuscole
      CodificaCharURL = pChar
      Exit Function
      
'Qui inizio con le codifiche
   Case 32  '  spazio
      CodificaCharURL = "%20"
      Exit Function
   
'Lettere accentate
   Case 224  '  
      CodificaCharURL = "%C3%A0"
      Exit Function
   Case 232  '  
      CodificaCharURL = "%C3%A8"
      Exit Function
   Case 233  '  
      CodificaCharURL = "%C3%A9"
      Exit Function
   Case 236  '  
      CodificaCharURL = "%C3%AC"
      Exit Function
   Case 242  '  
      CodificaCharURL = "%C3%B2"
      Exit Function
   Case 249  '  
      CodificaCharURL = "%C3%B9"
      Exit Function
   
'PIU' USATI
   Case 34  '  "
      CodificaCharURL = "%22"
      Exit Function
   Case 39  '  '
      CodificaCharURL = "%27"
      Exit Function
   Case 43  '  +
      CodificaCharURL = "%2B"
      Exit Function
   Case 44  '  ,
      CodificaCharURL = "%2C"
      Exit Function
   Case 45  '  -
      CodificaCharURL = "%2D"
      Exit Function
   Case 46  '  .
      CodificaCharURL = "%2E"
      Exit Function
   Case 47  '  /
      CodificaCharURL = "%2F"
      Exit Function
   Case 58  '  :
      CodificaCharURL = "%3A"
      Exit Function
   Case 59  '  ;
      CodificaCharURL = "%3B"
      Exit Function
   Case 63  '  ?
      CodificaCharURL = "%3F"
      Exit Function
   Case 64  '  @
      CodificaCharURL = "%40"
      Exit Function
   Case 37  '  %
      CodificaCharURL = "%25"
      Exit Function
   Case 38  '  &
      CodificaCharURL = "%26"
      Exit Function
   Case 40  '  (
      CodificaCharURL = "%28"
      Exit Function
   Case 41  '  )
      CodificaCharURL = "%29"
      Exit Function
   Case 42  '  *
      CodificaCharURL = "%2A"
      Exit Function
   Case 128  '  
      CodificaCharURL = "%E2%82%AC"
      Exit Function
   Case 95  ' _ '
      CodificaCharURL = "%5F"
      Exit Function

'MENO USATI
   Case 60  '  <
      CodificaCharURL = "%3C"
      Exit Function
   Case 61  '  =
      CodificaCharURL = "%3D"
      Exit Function
   Case 62  '  >
      CodificaCharURL = "%3E"
      Exit Function
   Case 91  '  [
      CodificaCharURL = "%5B"
      Exit Function
   Case 92  '  \
      CodificaCharURL = "%5C"
      Exit Function
   Case 93  '  ]
      CodificaCharURL = "%5D"
      Exit Function
   Case 94  '  ^
      CodificaCharURL = "%5E"
      Exit Function
   Case 123  '  {
      CodificaCharURL = "%7B"
      Exit Function
   Case 124  '  |
      CodificaCharURL = "%7C"
      Exit Function
   Case 125  '  }
      CodificaCharURL = "%7D"
      Exit Function
   Case 126  '  ~
      CodificaCharURL = "%7E"
      Exit Function
   Case 35  '  #
      CodificaCharURL = "%23"
      Exit Function
   
   Case Else
      CodificaCharURL = pChar
   End Select
' Eccco la lista dei caratteri che necessitano di una codifica particolare :
' Carattere Codifica URL
' Tabulazione %09
' Spazio %20
' " %22
' # %23
' % %25
' & %26
' ( %28
' ) %29
' + %2B
' , %2C
' . %2E
' / %2F
' : %3A
' ; %3B
' < %3C
' = %3D
' > %3E
' ? %3F
' @ %40
' [ %5B
' \ %5C
' ] %5D
' ^ %5E
' ' %60
' { %7B
' | %7C
' } %7D
' ~ %7E

End Function


Public Function VerificaBOOLEANA(strRicerca As String) As Boolean
   Dim RS As ADODB.Recordset
   
   Set RS = New ADODB.Recordset
   RS.Open strRicerca, ConnDBPrimo, adOpenStatic
   If Not RS.EOF Then
      VerificaBOOLEANA = True
   Else
      VerificaBOOLEANA = False
   End If
   RS.Close
   Set RS = Nothing
End Function


Public Function ImpostaNumCelConPrefInternaz(pNumCel As String, pPrefIntern As String) As String
   'Controllo che ci sia il prefisso internazionale all'inizio
   If Mid(pNumCel, 1, 1) = "+" Then
      ImpostaNumCelConPrefInternaz = pNumCel
   ElseIf Mid(pNumCel, 1, 2) = "00" Then  'Nel caso si sia registrato sul cliente il prefisso "0039" anzich "+39"
      ImpostaNumCelConPrefInternaz = pNumCel
   Else 'Se non c'e' lo inserisco
      ImpostaNumCelConPrefInternaz = pPrefIntern & pNumCel
   End If
End Function

Public Sub VerificaEsistenzaPathCartella(pPathCartella As String, Optional pSoloControllo As Boolean, Optional prEsistenza As Boolean)
   'Questa sub serve per controllare l'esistenza di una cartella e se non esiste la crea _
    salvo che il parametro pSoloControllo non si a TRUE. In questo caso effettua SOLO il controllo. _
    L'esito dell'esistenza  passato al parametro di ritorno prEsistenza (questo l'ho fatto perch _
    non ho voluto trasformare la Sub in Funzione perch gi usata all'interno del programma)
   
   Dim MyFolder As String
   
   'restituisce una stringa vuota se la cartella non esiste
   MyFolder = Dir(pPathCartella, vbDirectory)
   If Len(Trim(MyFolder)) = 0 Then
   'crea la cartella
      If pSoloControllo = False Then MkDir pPathCartella
      prEsistenza = False
   Else
      prEsistenza = True
   End If

End Sub


Public Function VerificaEsistenzaFile(pPathFile As String) As Boolean
   Dim MyFile As String
            
   'restituisce una stringa vuota se la cartella non esiste
   MyFile = Dir(pPathFile, vbNormal)
   If Len(Trim(MyFile)) = 0 Then
      'Il file non esiste
      VerificaEsistenzaFile = False
   Else
      'Il file esiste
      VerificaEsistenzaFile = True
   End If

End Function

